#!/bin/bash

# PiVPN watchdog - restarts openvpn if tun0 disappears.
# Runs via root crontab every 5 minutes.
# Skips check if service started < 30s ago (avoids race during init).
#
# Install:
#   1. Copy to ~/.local/bin/pivpn-watchdog.sh
#   2. chmod +x ~/.local/bin/pivpn-watchdog.sh
#   3. sudo crontab -e          (edits ROOT's crontab -- required
#      because systemctl restart needs root privileges; a user
#      crontab would fail silently with no way to authenticate)
#   4. Add: */5 * * * * /home/YOUR_USER/.local/bin/pivpn-watchdog.sh

if systemctl is-active --quiet openvpn-client@pivpn.service; then
    active_ts=$(systemctl show openvpn-client@pivpn.service --property=ActiveEnterTimestamp --value)
    if [ -n "$active_ts" ]; then
        active_epoch=$(date -d "$active_ts" +%s 2>/dev/null || echo 0)
        now_epoch=$(date +%s)
        age=$(( now_epoch - active_epoch ))
        if [ "$age" -lt 30 ]; then
            exit 0
        fi
    fi

    if ! ip link show tun0 &>/dev/null; then
        logger "PiVPN watchdog: tun0 missing (service up ${age:-?}s), restarting"
        systemctl restart openvpn-client@pivpn.service
    fi
fi
