#!/bin/bash
set -euo pipefail

# Unmount all NAS shares safely (won't hang on dead NFS)
# CUSTOMIZE: Replace with your actual NFS mount points
MOUNTS=(/mnt/Share1 /mnt/Share2 /mnt/Share3)

is_mounted() {
  awk -v t="$1" '$5==t {found=1} END{exit(found?0:1)}' /proc/self/mountinfo
}

for m in "${MOUNTS[@]}"; do
  is_mounted "$m" && sudo umount -l "$m" || true
done

notify-send "NAS" "Unmount done ✅"
