#!/usr/bin/env bash
# pivpn-toggle.sh
#
# What this does:
# - Toggles your PiVPN connection using the systemd OpenVPN client unit:
#     openvpn-client@pivpn
# - If the service is active:
#     - runs your pivpn-disconnect.sh helper (silently)
# - If the service is inactive:
#     - runs your pivpn-connect.sh helper (silently)
#
# Why helper scripts are used:
# - Your connect/disconnect scripts can handle extra logic like:
#     - coordinating with PIA (disconnecting/restoring)
#     - routes, DNS, cleanup, notifications, etc.
#
# Dependencies / assumptions:
# - systemd + an OpenVPN client unit named openvpn-client@pivpn
# - These helper scripts exist:
#     ~/.local/bin/pivpn-connect.sh
#     ~/.local/bin/pivpn-disconnect.sh

set -euo pipefail

SERVICE="openvpn-client@pivpn"

if systemctl is-active --quiet "$SERVICE"; then
  # PiVPN is ON → disconnect (and maybe restore PIA)
  ~/.local/bin/pivpn-disconnect.sh >/dev/null 2>&1
else
  # PiVPN is OFF → connect (and maybe drop PIA)
  ~/.local/bin/pivpn-connect.sh >/dev/null 2>&1
fi

