#!/usr/bin/env bash
# pia-toggle.sh
#
# What this does:
# - Simple toggle for Private Internet Access (PIA) using piactl:
#     - If PIA is Connected or Connecting -> disconnect
#     - Otherwise -> connect
# - Enables `piactl background` so the daemon can run headless (no GUI needed)
#
# Typical usage:
# - Called from a Waybar button (custom module "on-click") or a keybind
#
# Dependencies / assumptions:
# - PIA is installed and `piactl` exists at /opt/piavpn/bin/piactl

PIACTL="/opt/piavpn/bin/piactl"

# Make sure daemon can run headless
$PIACTL background enable >/dev/null 2>&1

# Read current connection state
state="$($PIACTL get connectionstate 2>/dev/null)"
if [[ "$state" == "Connected" || "$state" == "Connecting" ]]; then
  # If already up (or coming up), disconnect
  $PIACTL disconnect
else
  # Otherwise connect
  $PIACTL connect
fi

