#!/bin/bash
# nas-unmount-all.sh
#
# What this does:
# - Unmounts a list of NAS mountpoints (if they are currently mounted)
# - Uses mountpoint(1) to check safely before unmounting
# - Uses sudo for umount (will prompt if sudo isn't warmed)
#
# Publish note:
# - Mount paths are obfuscated for privacy. Replace with your real mountpoints.

set -euo pipefail

# PRIVATE: mount paths obfuscated for publishing
MOUNTS=(/mnt/mount_point_1 /mnt/mount_point_2 /mnt/mount_point_3 /mnt/mount_point_4)

for m in "${MOUNTS[@]}"; do
  # If it's a mountpoint, unmount it; otherwise do nothing.
  # "|| true" prevents a failure from killing the entire script.
  mountpoint -q "$m" && sudo umount "$m" || true
done

notify-send "NAS" "Unmount done ✅"

