#!/usr/bin/env bash
# gparted-fixed.sh
#
# What this does:
# - Launches GParted as root via pkexec (PolicyKit)
# - Explicitly passes through the key environment variables that GUI apps often
#   need under Wayland/Hyprland, so GParted reliably opens instead of failing
#   with "cannot open display" / missing runtime dir issues.
#
# Why this exists:
# - Some GUI apps launched with pkexec don't inherit the right environment.
# - Setting XDG_RUNTIME_DIR / WAYLAND_DISPLAY / DISPLAY / XAUTHORITY makes the
#   privileged GUI session connect properly to your current desktop session.

set -euo pipefail

# Current user numeric ID (used to build /run/user/<uid>)
USER_ID="$(id -u)"

# Run GParted as root with a sane GUI environment
exec pkexec env \
  XDG_RUNTIME_DIR="/run/user/$USER_ID" \
  WAYLAND_DISPLAY="${WAYLAND_DISPLAY:-wayland-1}" \
  DISPLAY="${DISPLAY:-:0}" \
  XAUTHORITY="${XAUTHORITY:-$HOME/.Xauthority}" \
  /usr/bin/gparted

